<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>I Am Awesome - Score</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>

    <video autoplay muted loop id="bg-video">
        <source src="assets/background.mp4" type="video/mp4">
    </video>

    <audio autoplay loop>
        <source src="assets/songs.mp3" type="audio/mp3">
    </audio>

    <div class="container">
        <h1>Congratulations!</h1>
        <p>Your Score: <span id="final-score"></span></p>
        <button class="btn" onclick="restartGame()">Kembali Ke Halaman Utama</button>
    </div>

    <script>
        // Get and display the score from localStorage
        document.getElementById("final-score").innerText = localStorage.getItem("score");

        function restartGame() {
            const username = localStorage.getItem("username");  // Assuming username is stored in localStorage
            const score = localStorage.getItem("score");

            // Send the score to the PHP script via fetch
            fetch("update_score.php", {
                method: "POST",
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded"
                },
                body: `username=${username}&score=${score}`
            })
            .then(response => response.text())
            .then(data => {
                console.log(data);  // Log the response from PHP
                localStorage.setItem("score", 0);  // Reset the score in localStorage
                window.location.href = "../../murid5/indexTahun5.php";  // Redirect to the game page
            })
            .catch(error => {
                console.error('Error:', error);
            });
        }
    </script>
</body>
</html>
